package centralSystemOld;

public class CentralSystem implements ICentralSystem {

	private Queue[] queues = {new Queue(), new Queue(), new Queue()};
	private ITicketPrinter ticketPrinter;
	
	public CentralSystem(ITicketPrinter ticketPrinter) {
		super();
		this.ticketPrinter = ticketPrinter;
	}

	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#addClientAtQueue(int)
	 */
	@Override
	public void addClientAtQueue(int index){
		queues[index].addClient();
		this.ticketPrinter.printTicket(queues[index].getTotalClient());
	}
	
	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#clientServedAtQueue(int)
	 */
	@Override
	public void clientServedAtQueue(int index){
		queues[index].clientServed();
	}
	
	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#getTotalClient(int)
	 */
	@Override
	public int getTotalClient(int index) {
		return queues[index].getTotalClient();
	}
	
	/* (non-Javadoc)
	 * @see centralSystem.ICentralSystem#getNextClient(int)
	 */
	@Override
	public int getNextClient(int index) {
		return queues[index].getNextClient();
	}
}
